@echo off
color 0A
title POS Email Setup Assistant

echo ================================================
echo          POS EMAIL SETUP ASSISTANT
echo ================================================
echo.

:MAIN_MENU
echo Please choose your email setup method:
echo.
echo 1. External SMTP (Gmail/Outlook) - RECOMMENDED
echo 2. Local SMTP Server (hMailServer)
echo 3. Check PHP Requirements
echo 4. Test Current Email Settings
echo 5. View Setup Guides
echo 6. Exit
echo.
set /p choice="Enter your choice (1-6): "

if "%choice%"=="1" goto EXTERNAL_SMTP
if "%choice%"=="2" goto LOCAL_SMTP
if "%choice%"=="3" goto CHECK_PHP
if "%choice%"=="4" goto TEST_EMAIL
if "%choice%"=="5" goto VIEW_GUIDES
if "%choice%"=="6" goto EXIT
goto INVALID_CHOICE

:EXTERNAL_SMTP
cls
echo ================================================
echo        EXTERNAL SMTP SETUP (RECOMMENDED)
echo ================================================
echo.
echo This method uses external email services like Gmail or Outlook.
echo It's the most reliable and doesn't require additional software.
echo.
echo Available options:
echo 1. Gmail SMTP Setup
echo 2. Outlook/Office365 SMTP Setup
echo 3. Back to main menu
echo.
set /p smtp_choice="Enter your choice (1-3): "

if "%smtp_choice%"=="1" goto GMAIL_SETUP
if "%smtp_choice%"=="2" goto OUTLOOK_SETUP
if "%smtp_choice%"=="3" goto MAIN_MENU
goto INVALID_CHOICE

:GMAIL_SETUP
cls
echo ================================================
echo              GMAIL SMTP SETUP
echo ================================================
echo.
echo Step 1: Enable 2-Step Verification in Gmail
echo   1. Go to https://myaccount.google.com/security
echo   2. Enable "2-Step Verification"
echo.
echo Step 2: Generate App Password
echo   1. Go to Security ^> 2-Step Verification ^> App Passwords
echo   2. Select "Other" and name it "POS System"
echo   3. Copy the 16-character password
echo.
echo Step 3: Configure POS System
echo   - Go to your POS Settings ^> Email Settings
echo   - SMTP Host: smtp.gmail.com
echo   - SMTP Port: 587
echo   - SMTP Username: your-gmail@gmail.com
echo   - SMTP Password: [16-character app password]
echo   - SMTP Encryption: TLS
echo.
echo Step 4: Test the configuration
echo.
pause
goto MAIN_MENU

:OUTLOOK_SETUP
cls
echo ================================================
echo           OUTLOOK/OFFICE365 SMTP SETUP
echo ================================================
echo.
echo Step 1: Prepare your Outlook account
echo   - Ensure you have a valid Outlook/Office365 account
echo   - If using 2FA, generate an App Password
echo.
echo Step 2: Configure POS System
echo   - Go to your POS Settings ^> Email Settings
echo   - SMTP Host: smtp.office365.com
echo   - SMTP Port: 587
echo   - SMTP Username: your-outlook@outlook.com
echo   - SMTP Password: [account password or app password]
echo   - SMTP Encryption: TLS
echo.
echo Step 3: Test the configuration
echo.
pause
goto MAIN_MENU

:LOCAL_SMTP
cls
echo ================================================
echo           LOCAL SMTP SERVER SETUP
echo ================================================
echo.
echo This method requires installing additional software on your computer.
echo.
echo Recommended: hMailServer (Free)
echo.
echo Step 1: Download hMailServer
echo   - Go to: https://www.hmailserver.com/download
echo   - Download and install the latest version
echo.
echo Step 2: Configure hMailServer
echo   - Choose "Use built-in database engine"
echo   - Set administrator password
echo   - Create domain: localhost
echo   - Create account: admin@localhost
echo.
echo Step 3: Configure POS System
echo   - SMTP Host: localhost
echo   - SMTP Port: 25
echo   - SMTP Username: admin@localhost
echo   - SMTP Password: [password you set]
echo   - SMTP Encryption: None
echo.
echo Would you like to download hMailServer now?
set /p download="Type 'y' to open download page, or any key to continue: "
if /i "%download%"=="y" start https://www.hmailserver.com/download
echo.
pause
goto MAIN_MENU

:CHECK_PHP
cls
echo ================================================
echo           CHECKING PHP REQUIREMENTS
echo ================================================
echo.
echo Running PHP requirements check...
php setup_guides\check_php_requirements.php
echo.
echo If you see any FAIL status above, you need to:
echo 1. Edit your php.ini file (usually in C:\xampp\php\php.ini)
echo 2. Enable the required extensions
echo 3. Restart Apache in XAMPP Control Panel
echo 4. Run this check again
echo.
pause
goto MAIN_MENU

:TEST_EMAIL
cls
echo ================================================
echo           TEST EMAIL SETTINGS
echo ================================================
echo.
echo To test your email settings:
echo.
echo 1. Open your web browser
echo 2. Go to your POS system
echo 3. Navigate to Settings ^> Email Settings
echo 4. Verify all SMTP settings are correct
echo 5. Click "Test Email Configuration"
echo 6. Check the test email inbox
echo.
echo If the test fails, check:
echo   - SMTP settings are correct
echo   - Internet connection is working
echo   - Firewall is not blocking SMTP ports
echo   - PHP extensions are enabled
echo.
pause
goto MAIN_MENU

:VIEW_GUIDES
cls
echo ================================================
echo              SETUP GUIDES
echo ================================================
echo.
echo Available setup guides:
echo.
echo 1. Gmail SMTP Setup Guide
echo 2. Outlook SMTP Setup Guide  
echo 3. Local SMTP Server Setup Guide
echo 4. PHP Requirements Checker
echo 5. Back to main menu
echo.
set /p guide_choice="Enter your choice (1-5): "

if "%guide_choice%"=="1" start notepad setup_guides\gmail_smtp_setup.md
if "%guide_choice%"=="2" start notepad setup_guides\outlook_smtp_setup.md
if "%guide_choice%"=="3" start notepad setup_guides\local_smtp_server_setup.md
if "%guide_choice%"=="4" start notepad setup_guides\check_php_requirements.php
if "%guide_choice%"=="5" goto MAIN_MENU

goto MAIN_MENU

:INVALID_CHOICE
echo.
echo Invalid choice. Please try again.
timeout /t 2 >nul
goto MAIN_MENU

:EXIT
cls
echo ================================================
echo         THANK YOU FOR USING POS EMAIL SETUP
echo ================================================
echo.
echo Summary of what you should do next:
echo.
echo 1. Choose your preferred email method (External SMTP recommended)
echo 2. Follow the setup instructions
echo 3. Configure your POS system email settings
echo 4. Test the email configuration
echo 5. If issues persist, check PHP requirements
echo.
echo For additional help:
echo - Check the setup guides in the setup_guides folder
echo - Run PHP requirements checker
echo - Contact support if needed
echo.
echo Press any key to exit...
pause >nul
exit 